% modulation and OFDM

%% Modulation scheme

if modulation_decision == 1
    
    % Initialization for QAM modulation

    nr_symbols_package = size(packages_bits,2)/log2(QAM_decision);
    
else
       
    % Initialization for PSK modulation
    
    nr_symbols_package = size(packages_bits,2)/log2(8);
    
end

% Preallocation for packages
    
packages_symbols = zeros(nr_packages, nr_symbols_package);

% Modulate each package

for ii=1:nr_packages
    
   packages_symbols(ii,:) = tx_modulation(packages_bits(ii,:), ...
    modulation_decision, QAM_decision, Eb);

end

       
%% OFDM

% If OFDM is used

if OFDM_decision == 1;
    
    % Preallocation    
    nr_OFDM_symbols_package = (nr_symbols_package/BlockLength)*L+nr_symbols_package/BlockLength*N;
    packages_OFDM_symbols = zeros(nr_packages, nr_OFDM_symbols_package);
    
    for ii=1:nr_packages
        
        % Apply OFDM on each package
        packages_OFDM_symbols(ii,:) = OFDM_transmitter_new(packages_symbols(ii,:),N,BlockLength, L);
       
    end
    
    % The packages use OFDM
    
    nr_package_samples = nr_OFDM_symbols_package;
    
else
    
    % The packages DO NOT use OFDM
    
    nr_package_samples = k*nr_symbols_package;
    
end